using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Xml;
using System.Collections.Generic;

public partial class XmlTextWriterTest : System.Web.UI.Page
{
    private string file;
	protected void Page_Load(object sender, EventArgs e)
	{
         file = Path.Combine(Request.PhysicalApplicationPath, @"App_Data\SuperProProductList_NoNamespace.xml");
	}
    
	protected void cmdCreateXml_Click(object sender, EventArgs e)
	{        
		FileStream fs = new FileStream(file, FileMode.Create);
		XmlTextWriter w = new XmlTextWriter(fs, null);

		w.WriteStartDocument();
		w.WriteStartElement("SuperProProductList");
		w.WriteComment("This file generated by the XmlTextWriter class.");
        
		// Write the first product.
		w.WriteStartElement("Product");
		w.WriteAttributeString("ID", "1");
		w.WriteAttributeString("Name", "Chair");

		w.WriteStartElement("Price");
		w.WriteString("49.33");
		w.WriteEndElement();

		w.WriteEndElement();

		// Write the second product.
		w.WriteStartElement("Product");
		w.WriteAttributeString("ID", "2");
		w.WriteAttributeString("Name", "Car");

		w.WriteStartElement("Price");
		w.WriteString("43399.55");
		w.WriteEndElement();

		w.WriteEndElement();

		// Write the third product.
		w.WriteStartElement("Product");
		w.WriteAttributeString("ID", "3");
		w.WriteAttributeString("Name", "Fresh Fruit Basket");

		w.WriteStartElement("Price");
		w.WriteString("49.99");
		w.WriteEndElement();

		w.WriteEndElement();

		// Close the root element.
		w.WriteEndElement();
		w.WriteEndDocument();
		w.Close();

		lblXml.Text = "File " + file + " written successfully.";
	}
	protected void cmdReadXml_Click(object sender, EventArgs e)
	{        
		FileStream fs = new FileStream(file, FileMode.Open);
		XmlTextReader r = new XmlTextReader(fs);

		// Store the whole file in a StringWriter (much quicker than using
		// string operations).
		StringWriter writer = new StringWriter();

		// Parse the file and read each node.
		while (r.Read())
		{
			writer.Write("<b>Type:</b> ");
			writer.Write(r.NodeType.ToString());
			writer.Write("<br>");

			if (r.Name != "")
			{
				writer.Write("<b>Name:</b> ");
				writer.Write(r.Name);
				writer.Write("<br>");
			}

			if (r.Value != "")
			{
				writer.Write("<b>Value:</b> ");
				writer.Write(r.Value);
				writer.Write("<br>");
			}

			if (r.AttributeCount > 0)
			{
				writer.Write("<b>Attributes:</b> ");
				for (int i = 0; i < r.AttributeCount; i++)
				{
					writer.Write("  ");
					writer.Write(r.GetAttribute(i));
					writer.Write("  ");
				}
				writer.Write("<br>");
			}
			writer.Write("<br>");
		}
		fs.Close();

		// Copy the string content into a label to display it.
		lblXml.Text = writer.ToString();

	}
	protected void cdmReadXmlAsObjects_Click(object sender, EventArgs e)
	{
		// Open a stream to the file.
		FileStream fs = new FileStream(file, FileMode.Open);
		XmlTextReader r = new XmlTextReader(fs);

		// Create a generic collection of products.
		List<Product> products = new List<Product>();

		// Loop through the products.
		while (r.Read())
		{
			if (r.NodeType == XmlNodeType.Element && r.Name == "Product")
			{
				Product newProduct = new Product();
				newProduct.ID = Int32.Parse(r.GetAttribute("ID"));
				newProduct.Name = r.GetAttribute("Name");

				// Get the rest of the subtags for this product.
				while (r.NodeType != XmlNodeType.EndElement)
				{
					r.Read();

					// Look for Price subtags.
					if (r.Name == "Price")
					{
						while (r.NodeType != XmlNodeType.EndElement)
						{
							r.Read();
							if (r.NodeType == XmlNodeType.Text)
							{
								newProduct.Price = Decimal.Parse(r.Value);
							}
						}
					}

					// You could check for other Product nodes
					// (like Available, Status, etc.) here.
				}

				// Add the product to the list.
				products.Add(newProduct);
			}
		}

		fs.Close();

		// Display the retrieved document.
		gridResults.DataSource = products;
		gridResults.DataBind();

	}
}
